//LIB
const puppeteer = require("puppeteer");
const fs = require('fs');
//--------------------------
const {openBrowser, updateBrowser, closeBrowser, deleteBrowser, getBrowserDetail, getBrowserList, getAliveBrowsersPids} = require('./request');
//--------------------------
(async () => {
    while (true) {
		const PROX_USERNAME = "sulfian";
		const PROX_PASSWORD = "PIANsayangTITIN";

		const PROX_ISP = "-amazon,-avast,-CloudIP,-clouvider,-contabo,-datacamp,-dedipath,-digitalocean,-expert,-expressVPN,-frantech,-google,-hetzner,-huawei,-intercom,-ipxo,-latitude,-leaseweb,-m247,-mediaconnective,-microsoft,-nexeon,-nordvpn,-ovh,-quadranet,-ukdedicated,-upcloud,-usdedicated,-vpn-,-vultr,-ReliableSite-cloud,-hosting,-server,-vps,-ProtonVPN,-Hostwinds";

		const totalPorts = 5;
		const startPort = 10000;

		const countries = [
			{ country: 'CA', ports: 1, isp: PROX_ISP },
			{ country: 'US', ports: 4, isp: PROX_ISP }
		];

		function proxyInfo(country, portNumber, isp, session = null) {
			if (session === null) {
				session = country;
			}

			return {
				country: country,
				proxy: "private.residential.proxyrack.net",
				port: portNumber.toString(),
				username: `${PROX_USERNAME};country=${country};isp=${isp};refreshSeconds=300;session=${session}`,
				password: PROX_PASSWORD
			};
		}

		function proxiesJSON(totalPorts, countries, startPort) {
			const jsonData = [];
			let currentPort = startPort;

			countries.forEach(countryData => {
				const { country, ports, isp } = countryData;

				for (let i = 0; i < ports; i++) {
					jsonData.push(proxyInfo(country, currentPort, isp));
					currentPort++;
				}
			});

			return jsonData;
		}

		const proxyLists = proxiesJSON(totalPorts, countries, startPort);
		const randomProxiesJSON = randomIndex(proxyLists);
		const selectedProxy = JSON.parse(JSON.stringify(randomProxiesJSON, null, 2));
		
		let country, proxy, port, username, password;
		proxyCountry = selectedProxy.country;
		proxy = selectedProxy.proxy;
		port = selectedProxy.port;
		username = selectedProxy.username;
		password = selectedProxy.password;
		// --------------------------
		let OSList;
		OSList = [
			{ name: "android", percentage: 25 },
			{ name: "iphone", percentage: 5 },
			{ name: "windows", percentage: 65 },
			{ name: "mac", percentage: 5 }
		];
		
        const OS = randomItem(OSList);
		// --------------------------
		let ostype, osx;
		if (OS === 'android') {ostype = 'Android'; osxLists	= ["Linux i686", "Linux armv7l"]; osx = osxLists[random(0, (osxLists.length - 1))];}
		else if (OS === 'iphone') {ostype	= 'IOS'; osx = 'iPhone';}
		else if (OS === 'mac') {ostype = 'PC'; osx = 'MacIntel';}
		else {ostype = 'PC'; osx = 'Win32';};
		// --------------------------
        const config = await createBrowser();
        let { id } = config;
        const res = await openBrowser({
            id,
            args: [
                '--allow-popups-during-page-unload',
                '--allow-running-insecure-content',
                '--allow-silent-push',
                '--disable-ipc-flooding-protection',
                '--disable-popup-blocking',
                '--disable-prompt-on-repost',
                '--enable-auto-reload',
                '--ignore-certifcate-errors',
                '--ignore-certifcate-errors-spki-list',
				'--proxy-server=' + proxy + ":" + port,
				'--proxy-bypass-list=PIANsayangTITIN.com,flashdailynews.com' // Tambahkan lists domain disini
            ],
            ignoreHTTPSErrors: true,
            loadExtensions: false,
            extractIp: false
        });
		
		if (res.success) {
            await connect(res, id)
        };		
		// --------------------------
		async function connect(res, id) {
			var startTime = new Date();
            // --------------------------
			let wsEndpoint = res.data.ws;
			
			try {
				const browser = await puppeteer.connect({
					browserWSEndpoint: wsEndpoint,
					defaultViewport: null,
					ignoreHTTPSErrors: true
				})
				
				const page = await browser.newPage();
				// --------------------------
				//Login Proxy
				await page.authenticate({ username: username, password: password });		  
				// --------------------------
				// Url list acak
				let targetUrl = randomLine('./url.txt');
				// --------------------------
				await page.setDefaultTimeout(0);
				await page.setDefaultNavigationTimeout(0);
				await page.goto(targetUrl, { waitUntil: ['networkidle0'] });
				try {
					// Klik dan scroll secara acak selama 15 detik
					for (let i = 0; i < 15; i++) {
						// Dapatkan ukuran halaman dalam konteks browser
						const { width, height } = await page.evaluate(() => ({width: document.body.clientWidth, height: document.body.clientHeight}));

						// Tentukan posisi acak
						const x = Math.floor(Math.random() * (width - 10)); const y = Math.floor(Math.random() * (height - 10));

						// Gerakkan mouse ke posisi acak dan klik
						await page.mouse.move(x, y);
						// await page.mouse.click(x, y); // Aktikan klik acak hapus //

						// Scroll secara acak
						await page.evaluate((scrollX, scrollY) => { window.scrollTo(scrollX, scrollY); }, x, y);

						// Tunggu 1 detik sebelum melakukan aksi berikutnya
						await sleep(1); // 1 detik
					}
				} catch (err) {
					// console.error(err);
				};
						
				var endTime = (new Date() - startTime) / 1000;

				console.log(`[+] SUCCESS`);
				console.log(`[+] URL: ${targetUrl}`);
				console.log(`[+] COUNTRY: ${proxyCountry}`);
				console.log(`[+] LOAD TIME: ${endTime}`);
				console.log(`--------------`);
				
				await closeBrowser(id);
				await deleteBrowser(id);
				
			} catch (err) {
				// console.error(err);
				
				await closeBrowser(id);
				await deleteBrowser(id);
			};
		};
		
		async function createBrowser() {
			try {
				const res = await updateBrowser({
					id: null,
					proxyMethod: 2,
					proxyType: 'noproxy',
					host: proxy,
					port: port,
					proxyUserName: username,
					proxyPassword: password,
					seq: null,
					browserFingerPrint: {
						coreVersion: '130',
						ostype: ostype, // PC|Android|IOS
						os: osx,
						ignoreHttpsErrors: true
					}
				});
				
				return res.data
			} catch (err) {
				// console.error(err);
				await closeBrowser(id);
			}
			return null
		};
    };
})();

// Delay
function sleep(timeout) {return new Promise(resolve => {setTimeout(resolve, timeout * 1000);});}

// Angka acak
function random(min, max) {return Math.floor(Math.random() * (max - min + 1)) + min;};

// Baris acak dari file
function randomLine(filename) {var data = fs.readFileSync(filename, 'utf8'); var lines = data.split('\n').filter(element => element !== ''); return lines[Math.floor(Math.random() * lines.length)];};

// Array acak
function randomIndex(lists) {const randomIndex = random(0, lists.length - 1); return lists[randomIndex];};

// List acak dengan Percent
function randomItem(list) {
    const totalPercent = list.reduce((sum, item) => sum + item.percentage, 0);
    const randomValue = Math.random() * totalPercent;
    let currentPercent = 0;
    for (const item of list) {
        currentPercent += item.percentage;
        if (randomValue <= currentPercent) {
            return item.name;
        }
    }
    return "empty";
};